#  ---------------------------------------------------------------------
#   XOAI Data Provider template
#    v1.0
#    January 2002
#  ------------------+--------------------+-----------------------------
#   Hussein Suleman  |   hussein@vt.edu   |    www.husseinsspace.com    
#  ------------------+--------------------+-+---------------------------
#   Department of Computer Science          |        www.cs.vt.edu       
#     Digital Library Research Laboratory   |       www.dlib.vt.edu      
#  -----------------------------------------+-------------+-------------
#   Virginia Polytechnic Institute and State University   |  www.vt.edu  
#  -------------------------------------------------------+-------------


package XOAI::XOAIDP;


use Pure::EZCGI;
use OAI::Utility;

use OAI::OAIDP;
use vars ('@ISA');
@ISA = ("OAI::OAIDP");


# constructor
sub new
{
   my ($classname) = @_;
   my $self = $classname->SUPER::new ();
   
   $self->{xoai_xmlnsprefix} = 'http://oai.dlib.vt.edu/XOAI/1.0',
   
   bless $self, $classname;
   return $self;
}


# destructor
sub dispose
{
   my ($self) = @_;
   $self->SUPER::dispose ();
}


# output XML HTTP header
sub xmlheader
{
   my ($self) = @_;

   # calculate timezone automatically
   my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime (time);
   my $timezone = sprintf ("%+03d:00", ((((($hour-(gmtime)[2]) % 24) + 11) % 24) - 11));
   my $datestring = sprintf ("%04d-%02d-%02dT%02d:%02d:%02d%s",
                    $year+1900, $mon+1, $mday, $hour, $min, $sec,
                    $timezone);

   "Content-type: text/xml\n\n".
   "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n".
   "<xoai:".$self->{'cgi'}->param ('verb')." ".
   "xmlns=\"$self->{'xmlnsprefix'}/OAI_".$self->{'cgi'}->param ('verb')."\" ".
   "xmlns:xoai=\"$self->{'xoai_xmlnsprefix'}/XOAI_".$self->{'cgi'}->param ('verb')."\" ".
   "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ".
   "xsi:schemaLocation=\"".
   "$self->{'xmlnsprefix'}/OAI_".$self->{'cgi'}->param ('verb')." ".
   "$self->{'xmlnsprefix'}/OAI_".$self->{'cgi'}->param ('verb').".xsd ".
   "$self->{'xoai_xmlnsprefix'}/XOAI_".$self->{'cgi'}->param ('verb')." ".
   "$self->{'xoai_xmlnsprefix'}/XOAI_".$self->{'cgi'}->param ('verb').".xsd".
   "\">\n\n".
   "<responseDate>$datestring</responseDate>\n".
   "<requestURL>".
   $self->{'cgi'}->param ('requestURL').
   $self->{'utility'}->lclean ($self->{'cgi'}->{'requestURL'}).
   "</requestURL>\n\n";
}


# output XML HTTP footer
sub xmlfooter
{
   my ($self) = @_;
   "\n</xoai:".$self->{'cgi'}->param ('verb').">\n";
}


# validate new date format
sub DateisValid
{
   my ($self, $date) = @_;

   if ($date =~ /^[0-9]{4}-[0-9]{2}-[0-9]{2}$/)
   { return $self->SUPER::DateisValid ($date); }

   if ($date !~ /^[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[\+\-][0-9]{2}:[0-9]{2}$/)
   { return 0; }
   
   my $hour = substr ($date, 11, 2);
   my $minute = substr ($date, 14, 2);
   my $second = substr ($date, 17, 2);

   if (($hour < 0) || ($hour > 23))
   { return 0; }
   if (($minute < 0) || ($minute > 59))
   { return 0; }
   if (($second < 0) || ($second > 59))
   { return 0; }
   
   return $self->SUPER::DateisValid (substr ($date, 0, 10));
}


# standard processing routine for PutRecord verb
sub PutRecord
{ 
   my ($self) = @_;

   my $identifier = $self->{'cgi'}->param ('identifier');
   my $metadata = $self->{'cgi'}->param ('metadata');
   my $about = $self->{'cgi'}->param ('about');
   my $metadataPrefix = $self->{'cgi'}->param ('metadataPrefix');
   my $sets = $self->{'cgi'}->param ('sets');
   my $status = $self->{'cgi'}->param ('status');

   if ($metadata eq '')
   {
      return $self->Error ("missing metadata parameter", 400);
   }
   if ($metadataPrefix eq '')
   {
      return $self->Error ("missing metadataPrefix parameter", 400);
   }

   my $metadataNamespace = '';
   my $metadataSchema = '';
   if ($metadata =~ /xsi:schemaLocation[\s]*=[\s]*"[\s]*[^\s]+[\s]+[^"\s]+"/)
   {
      $metadataNamespace = $metadata;
      $metadataSchema = $metadata;
      $metadataNamespace =~ s/^(.*)xsi:schemaLocation[\s]*=[\s]*"[\s]*([^\s]+)[\s]+[^"\s]+(.*)$/$2/o;
      $metadataSchema =~ s/^(.*)xsi:schemaLocation[\s]*=[\s]*"[\s]*[^\s]+[\s]+([^"\s]+)(.*)$/$2/o;
   }
   if ($metadataNamespace eq '')
   {
      return $self->Error ("missing namespace in root tag", 400);
   }
   if ($metadataSchema eq '')
   {
      return $self->Error ("missing schema in root tag", 400);
   }

   # calculate datestamp
   my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime (time);
   my $datestamp = sprintf ("%04d-%02d-%02d", $year+1900, $mon+1, $mday);

   my @setlist = grep { $_ !~ /^[\s]*$/ } split (',', $sets);
   
   $self->Archive_PutRecord ($identifier, $datestamp, $metadata,
      $metadataPrefix, $metadataNamespace, $metadataSchema,
      $about, $status, @setlist);
   
   $self->xmlheader.$self->xmlfooter;
}


# overridden ListIdentifiers for cater for responseContainer
sub ListIdentifiers
{
   my ($self) = @_;

   my ($set, $from, $until);
   my ($resumptionToken, $allrows, $responseContainer);

   $resumptionToken = $self->{'cgi'}->param ('resumptionToken');
   if ($resumptionToken eq '')
   {
      $set = $self->{'cgi'}->param ('set');
      $from = $self->{'cgi'}->param ('from');
      $until = $self->{'cgi'}->param ('until');

      if (($from ne '') && (!($self->DateisValid ($from))))
      {
         return $self->Error ("illegal from parameter", 400);
      }
      if (($until ne '') && (!($self->DateisValid ($until))))
      {
         return $self->Error ("illegal until parameter", 400);
      }
   }

   ($allrows, $resumptionToken, $responseContainer) = 
     $self->Archive_ListIdentifiers ($set, $from, $until, $resumptionToken);

   my $buffer = $self->xmlheader;
   foreach my $recref (@$allrows)
   {
      $buffer .= "<identifier>$recref->{'urn'}</identifier>"
   }
   if ((defined $resumptionToken) && ($resumptionToken ne ''))
   {
      $buffer .= "\n<resumptionToken>$resumptionToken</resumptionToken>\n";
   }
   if ((defined $responseContainer) && ($responseContainer ne ''))
   {
      $buffer .= "\n<xoai:responseContainer>$responseContainer</xoai:responseContainer>\n";
   }
   
   $buffer.$self->xmlfooter;
}


# overridden ListRecords for cater for responseContainer
sub ListRecords
{
   my ($self) = @_;

   my ($set, $from, $until, $metadataPrefix);
   my ($resumptionToken, $allrows, $responseContainer);

   $resumptionToken = $self->{'cgi'}->param ('resumptionToken');
   if ($resumptionToken eq '')
   {
      $set = $self->{'cgi'}->param ('set');
      $from = $self->{'cgi'}->param ('from');
      $until = $self->{'cgi'}->param ('until');
      $metadataPrefix = $self->{'cgi'}->param ('metadataPrefix');

      if ($metadataPrefix eq '')
      {
         return $self->Error ("missing metadataPrefix parameter", 400);
      }
      if (($from ne '') && (!($self->DateisValid ($from))))
      {
         return $self->Error ("illegal from parameter", 400);
      }
      if (($until ne '') && (!($self->DateisValid ($until))))
      {
         return $self->Error ("illegal until parameter", 400);
      }
   }

   ($allrows, $resumptionToken, $responseContainer, $metadataPrefix) =
     $self->Archive_ListRecords ($set, $from, $until, $metadataPrefix, $resumptionToken);

   my $buffer = $self->xmlheader;
   foreach my $recref (@$allrows)
   { 
      $buffer .= $self->Archive_FormatRecord ($recref, $metadataPrefix);
   }
   if ((defined $resumptionToken) && ($resumptionToken ne ''))
   {
      $buffer .= "\n<resumptionToken>$resumptionToken</resumptionToken>\n";
   }
   if ((defined $responseContainer) && ($responseContainer ne ''))
   {
      $buffer .= "\n<xoai:responseContainer>$responseContainer</xoai:responseContainer>\n";
   }

   $buffer.$self->xmlfooter;
}


# XOAI-specific identification
sub Archive_Identify
{
   my ($self) = @_;
   
   my $id = $self->SUPER::Archive_Identify ();
   
   if (! exists $id->{'description'})
   { 
      $id->{'description'} = []; 
   }
   my $desc = {
      'odl-description' => [[ 
         {
            'xmlns' => $self->{xoai_xmlnsprefix}.'/odl-description',
            'xsi:schemaLocation' => 
                       $self->{xoai_xmlnsprefix}.'/odl-description '.
                       $self->{xoai_xmlnsprefix}.'/odl-description.xsd'
         },
         {
            'protocol' => 'XOAI',
            'version'  => '1.0',
            'mdorder'  => [ qw ( protocol version ) ]
         } 
      ]]
   };
   push (@{$id->{'description'}}, $desc);
   
   $id;
}


# stub routine for PutRecord
sub Archive_PutRecord
{
   my ($self, $identifier, $datestamp, $metadata, $metadataPrefix,
       $metadataNamespace, $metadataSchema, $about, $status, @setlist) = @_;
}


# stub routine for ListRecords
sub Archive_ListRecords
{
   my ($self, $set, $from, $until, $metadataPrefix, $resumptionToken) = @_;
   
   my $results = [];
   my @allrows = ();
   my $responseContainer = '';
   $resumptionToken = '';

   ( \@allrows, $resumptionToken, $responseContainer, $metadataPrefix );
}


# stub routine for ListIdentifiers
sub Archive_ListIdentifiers
{
   my ($self, $set, $from, $until, $resumptionToken) = @_;

   my $results = [];
   my @allrows = ();
   my $responseContainer = '';
   $resumptionToken = '';

   ( \@allrows, $resumptionToken, $responseContainer );
}


# main loop to process parameters and call appropriate verb handler
sub Run
{
   my ($self) = @_;

   if (! exists $self->{'cgi'})
   {
      $self->{'cgi'} = new Pure::EZCGI;
   }

   # run appropriate handler procedure
   if ($self->{'cgi'}->param ('verb') eq 'PutRecord')
   { print $self->PutRecord; }
   else
   { $self->SUPER::Run (); }
}


1;


