#  ---------------------------------------------------------------------
#   Log file manager
#    v1.0
#    January 2002
#  ------------------+--------------------+-----------------------------
#   Hussein Suleman  |   hussein@vt.edu   |    www.husseinsspace.com    
#  ------------------+--------------------+-+---------------------------
#   Department of Computer Science          |        www.cs.vt.edu       
#     Digital Library Research Laboratory   |       www.dlib.vt.edu      
#  -----------------------------------------+-------------+-------------
#   Virginia Polytechnic Institute and State University   |  www.vt.edu  
#  -------------------------------------------------------+-------------


package Pure::Log;


# use minimal buffering
$| = 1;


# constructor - create (if necessary) and open log file
sub new
{
   my ($classname, $filename) = @_;

   my $self = {};
   bless $self, $classname;

   local (*FILE);   
   open (FILE, ">>$filename");
   FILE->autoflush (1);
   $self->{file} = *FILE;
   
   return $self;
}


# add a dated entry to the file
sub log
{
   my ($self, $entry) = @_;
   local (*FILE) = $self->{file};

   my $timestamp = substr (localtime, 0, -8);
   print FILE "$timestamp : $entry\n";
}


# destructor - close log file
sub DESTROY
{
   my ($self) = @_;
   local (*FILE) = $self->{file};   

   close (FILE);
}


1;

