#  ---------------------------------------------------------------------
#   Semaphores for unix - atomic test-and-set locks
#    v1.0
#    January 2002
#  ------------------+--------------------+-----------------------------
#   Hussein Suleman  |   hussein@vt.edu   |    www.husseinsspace.com    
#  ------------------+--------------------+-+---------------------------
#   Department of Computer Science          |        www.cs.vt.edu       
#     Digital Library Research Laboratory   |       www.dlib.vt.edu      
#  -----------------------------------------+-------------+-------------
#   Virginia Polytechnic Institute and State University   |  www.vt.edu  
#  -------------------------------------------------------+-------------


package Pure::LockTS;


use Pure::LockB;


# constructor
sub new 
{
   my ($classname, $filename) = @_;
   my $self = {
      filename => $filename
   };
   bless $self, $classname;
   return $self;
}


# test for lock in an atomic operation
sub test
{
   my ($self) = @_;
   my $l = new Pure::LockB ('TS.lock');
   if (-e $self->{filename})
   {
      $l->unlock;
      return 0;
   }
   else
   {
      system "touch $self->{filename}";
      $l->unlock;
      return 1;
   }
}


# atomically clear a lock
sub clear
{
   my ($self) = @_;
   my $l = new Pure::LockB ('TS.lock');
   unlink $self->{filename};
   $l->unlock;
}


1;
