#  ---------------------------------------------------------------------
#   Semaphores for unix - simple blocking locks
#    v1.0
#    January 2002
#  ------------------+--------------------+-----------------------------
#   Hussein Suleman  |   hussein@vt.edu   |    www.husseinsspace.com    
#  ------------------+--------------------+-+---------------------------
#   Department of Computer Science          |        www.cs.vt.edu       
#     Digital Library Research Laboratory   |       www.dlib.vt.edu      
#  -----------------------------------------+-------------+-------------
#   Virginia Polytechnic Institute and State University   |  www.vt.edu  
#  -------------------------------------------------------+-------------


package Pure::LockB;


# constructor (and locker)
sub new
{
   my ($classname, $key) = @_;
   my $self = {};
   bless $self, $classname;
   $self->lock ($key);
   return $self;
}


# lock (or block)
sub lock
{
   my ($self, $key) = @_;
   open (LOCKLOCK, ">$key");
   flock (LOCKLOCK, 2);
   $self->{lock} = *LOCKLOCK;
}
   

# unlock
sub unlock
{
   my ($self) = @_;
   close ($self->{lock});
}


# destructor (and unlocker)
sub DESTROY
{
   my ($self) = @_;
   $self->unlock;
}


1;
