#  ---------------------------------------------------------------------
#   HTTP downloader in pure-perl to mimic LWP functionality
#    v1.0
#    January 2002
#  ------------------+--------------------+-----------------------------
#   Hussein Suleman  |   hussein@vt.edu   |    www.husseinsspace.com    
#  ------------------+--------------------+-+---------------------------
#   Department of Computer Science          |        www.cs.vt.edu       
#     Digital Library Research Laboratory   |       www.dlib.vt.edu      
#  -----------------------------------------+-------------+-------------
#   Virginia Polytechnic Institute and State University   |  www.vt.edu  
#  -------------------------------------------------------+-------------


package Pure::EZHTTP;


use IO::Socket;


# constructor
sub new
{
   my ($classname, %parmlist) = @_;
   my $self = { 
      agent   => '',
      code    => 500,
      content => '',
      headers => {},
      message => '',
   };
   if (%parmlist)
   {
      $self->{parmlist} = \%parmlist;
   }
   bless $self, $classname;
   return $self;
}


# set the name of the user agent
sub agent
{
   my ($self, $newagent) = @_;
   if (defined $newagent)
   {
      $self->{agent} = $newagent;
   }
   return $self->{agent};
}


# submit an HTTP request 
sub request
{
   my ($self, $request) = @_;
   
   # handle GET request
   if ($request->{parmlist}->{'GET'} ne '')
   {
      my $url = $request->{parmlist}->{'GET'};
      my ($host, $port, $path);

      if ($url =~ /http:\/\/([^:\/]+)(:([0-9]+))?([^#]*)(.*)/)
      {
         $host = $1;
         $port = defined $3 && $3 ne '' ? $3 : '80';
         $path = defined $4 && $4 ne '' ? $4 : '/';
      }
      
      my $EOL = "\015\012";
      my $BLANK = $EOL x 2;

      # make connection
      my $remote = new IO::Socket::INET ( Proto=>'tcp', PeerAddr=>$host, PeerPort=>$port);
      unless ($remote) # cannot connect
      {
         return $request;
      }
      
      $remote->autoflush(1);

      print $remote "GET $path HTTP/1.0\n".
                    "Host: $host" . $BLANK;
      
      # get return status code
      my $aline = <$remote>;
      if ($aline =~ /HTTP\/[^ ]* ([0-9]+)(.*)/)
      {
         $request->{code} = $1;
         $request->{message} = $2;
         $request->{message} =~ s/\s*(.*)/$1/;
      }
      
      # get headers
      while ($aline = <$remote>) 
      {
         if ($aline =~ /^[\s]*$/)
         {
            last;
         }
         elsif ($aline =~ /([^:]+): (.*)/)
         {
            $request->{headers}->{$1} = $2;
         }
      }
      
      # get body
      while ($aline = <$remote>) 
      {
         $request->{content} .= $aline;
      }
      
      close $remote;
   }
   
   return $request;
}


# retrieve HTTP status code
sub code
{
   my ($self) = @_;
  
   return $self->{code};
}


# retrieve HTTP status message
sub message
{
   my ($self) = @_;
  
   return $self->{message};
}


# retrieve HTTP header by name
sub header
{
   my ($self, $header) = @_;
   
   return $self->{headers}->{$header};
}


# retrieve HTTP body
sub content
{
   my ($self) = @_;
   
   return $self->{content};
}


1;


