#  ---------------------------------------------------------------------
#   Replace pure-perl module to process CGI parameters
#    v1.0
#    January 2002
#  ------------------+--------------------+-----------------------------
#   Hussein Suleman  |   hussein@vt.edu   |    www.husseinsspace.com    
#  ------------------+--------------------+-+---------------------------
#   Department of Computer Science          |        www.cs.vt.edu       
#     Digital Library Research Laboratory   |       www.dlib.vt.edu      
#  -----------------------------------------+-------------+-------------
#   Virginia Polytechnic Institute and State University   |  www.vt.edu  
#  -------------------------------------------------------+-------------


package Pure::EZCGI;


# constructor
sub new
{
   my ($classname) = shift;
   my $self = {};

   # get variables from environment or stdio
   $self->{qstring} = defined $ENV{'QUERY_STRING'} ? $ENV{'QUERY_STRING'} : '';
   if ($self->{qstring} eq '')
   { $self->{qstring} = <STDIN>; }
   if (! defined $self->{qstring})
   {
      $self->{qstring} = '';
   }

   # split up into individual name/value pairs and process escaped chars
   my @parray=split (/[=&]/, $self->{qstring});
   for ( my $i=0; $i<=$#parray; $i++ )
   {
      $parray[$i] =~ s/\+/ /g;
      $parray[$i] =~ s/\n//g;
      $parray[$i] =~ s/%[0-9A-F][0-9A-F]/sprintf("%c", hex (substr ($&, 1)))/ge;
      while (substr ($parray[$i], 0, 1) eq ' ')
      { $parray[$i] = substr ($parray[$i], 1); }
      while ((substr ($parray[$i], length ($parray[$i])-1, 1) eq ' ') || 
             (substr ($parray[$i], length ($parray[$i])-1, 1) eq "\r") ||
             (substr ($parray[$i], length ($parray[$i])-1, 1) eq "\n"))
      { chop $parray[$i]; }
   }
   if ($#parray % 2 == 0)
   {
      push (@parray, '');
   }

   # store in array and variables
   $self->{parray} = [ @parray ];
   my $server_name = defined $ENV{SERVER_NAME} ? $ENV{SERVER_NAME} : 'server.name';
   my $script_name = defined $ENV{SCRIPT_NAME} ? $ENV{SCRIPT_NAME} : '/scriptname';
   my $server_port = defined $ENV{SERVER_PORT} ? $ENV{SERVER_PORT} : '80';
   $self->{baseURL} = "http://$server_name:".$server_port.$script_name;
   $self->{requestURL} = "$self->{baseURL}?$self->{qstring}";

   bless $self, $classname;
   return $self;
}


# retrieve a single value or a list of values for a given parameter
sub param
{
   my ($self, $name) = @_;
   
   if (defined $name)
   {
      my @results = ();
      for ( my $i=0; $i<=$#{$self->{parray}}; $i+=2 )
      {
         if ($self->{parray}->[$i] eq $name)
         {
            push (@results, $self->{parray}->[$i+1]);
         }
      }
      
      if (wantarray)
      {
         return @results;
      }
      else
      {
         if ($#results >= 0)
         {
            return $results[0];
         }
         else
         {
            return '';
         }
      }
   }
   else
   {
      my @results = ();
      for ( my $i=0; $i<=$#{$self->{parray}}; $i+=2 )
      {
         my $found = 0;
         foreach my $result (@results)
         {
            if ($result eq $self->{parray}->[$i])
            {
               $found = 1;
            }
         }
         if ($found == 0)
         {
            push (@results, $self->{parray}->[$i]);
         }
      }
      
      return @results;
   }
}


1;
