#  ---------------------------------------------------------------------
#   OAI Service Provider template (OAI-PMH v1.1)
#    v1.1
#    January 2002
#  ------------------+--------------------+-----------------------------
#   Hussein Suleman  |   hussein@vt.edu   |    www.husseinsspace.com    
#  ------------------+--------------------+-+---------------------------
#   Department of Computer Science          |        www.cs.vt.edu       
#     Digital Library Research Laboratory   |       www.dlib.vt.edu      
#  -----------------------------------------+-------------+-------------
#   Virginia Polytechnic Institute and State University   |  www.vt.edu  
#  -------------------------------------------------------+-------------


package OAI::OAISP;


use Pure::EZHTTP;


# constructor
sub new
{
   my ($classname, $baseURL) = @_;
   my $self = {
      baseURL => $baseURL,
   };
   bless $self, $classname;
   return $self;
}


# destructor
sub dispose
{
   my ($self) = @_;
}


# retrieve OAI response, with support for automatic retries
sub getHTTP
{
   my ($self, $url) = @_;

   # create a user agent object
   my $ua = new Pure::EZHTTP;
   $ua->agent("VT OAI SP/1.0 " . $ua->agent);

   # create a request
   my $req = new Pure::EZHTTP GET => $url;

   my $state = 0;
   my $res;
   while ($state == 0)
   {
      # pass request to the user agent and get a response back
      $res = $ua->request($req);
      
      if ($res->code == 503)
      {
         my $sleep = $res->header ('Retry-After');
         if (not defined ($sleep) || ($sleep < 0) || ($sleep > 86400))
         { $state = 1;}
         else
         { sleep ($sleep); }
      }
      else
      { $state = 1; }
   }
   
   # return results to caller
   $res;
}


# standard verb handler to issue any request
#  example: doOAI ('ListIdentifiers', { set=>'test', from=>'2000-01-01' })
sub doOAI
{
   my ($self, $verb, $parameters) = @_;
   
   my $requesturl = $self->{'baseURL'}.'?verb='.$verb;
   
   if (defined $parameters)
   {
      foreach my $key (keys %$parameters)
      {
         if ($parameters->{$key} ne '')
         {
            my $value = $parameters->{$key};
            $value =~ s/%/%25/gos;
            $value =~ s/#/%23/gos;
            $value =~ s/\?/%3F/gos;
            $value =~ s/:/%3A/gos;
            $value =~ s/\//%2F/gos;
            $value =~ s/\+/%2B/gos;
            $value =~ s/=/%3D/gos;
            $value =~ s/&/%26/gos;
            $value =~ s/\n/%0A/gos;
            $value =~ s/\r/%0D/gos;
            $value =~ s/ /\+/gos;
            $requesturl .= "&$key=$value";
         }
      }
   }
   
   $self->getHTTP ($requesturl);
}


1;


