#!/usr/bin/perl -w -I.
use strict;

#  ---------------------------------------------------------------------
#   Test script for browsing engine
#    v2.0
#    April 2002
#  ------------------+--------------------+-----------------------------
#   Hussein Suleman  |   hussein@vt.edu   |    www.husseinsspace.com    
#  ------------------+--------------------+-+---------------------------
#   Department of Computer Science          |        www.cs.vt.edu       
#     Digital Library Research Laboratory   |       www.dlib.vt.edu      
#  -----------------------------------------+-------------+-------------
#   Virginia Polytechnic Institute and State University   |  www.vt.edu  
#  -------------------------------------------------------+-------------


use FindBin;
use lib "$FindBin::Bin/../../lib";

use ODL::DBBrowse::BrowseDP;


sub main
{
   print "Test Browse\n\n";
   
   # get/check/set parameters
   if ($#ARGV == -1)
   {
      print "  syntax : testbrowse.pl \'<query>\' [ <start> ] [ <stop> ]\n\n";
      exit;
   }
   my $start = 1;
   my $stop = 10;
   if ($#ARGV > 0)
   {
      $start = $ARGV[1];
   }
   if ($#ARGV > 1 )
   {
      $stop = $ARGV[2];
   }

   # run browse operation
   chdir "$FindBin::Bin";
   my $br = new ODL::DBBrowse::BrowseDP ('config.xml');
   my $results = $br->browse ($ARGV[0], $start, $stop);
   $br->dispose;

   # output results
   if ($#$results > 0)
   {
      print "List of identifiers in result set:\n";
   }
   for ( my $i=0; $i<$#$results; $i++ )
   {
      print "  $results->[$i]\n";
   }
   if ($#$results > 0)
   {
      print "\nTotal hits : $results->[-1]\n\n";
   }
}

main;
