#!/usr/bin/perl -w -I.
use strict;

#  ---------------------------------------------------------------------
#   Harvest data from the source archive
#    v2.0
#    April 2002
#  ------------------+--------------------+-----------------------------
#   Hussein Suleman  |   hussein@vt.edu   |    www.husseinsspace.com    
#  ------------------+--------------------+-+---------------------------
#   Department of Computer Science          |        www.cs.vt.edu       
#     Digital Library Research Laboratory   |       www.dlib.vt.edu      
#  -----------------------------------------+-------------+-------------
#   Virginia Polytechnic Institute and State University   |  www.vt.edu  
#  -------------------------------------------------------+-------------


use FindBin;
use lib "$FindBin::Bin/../../lib";

use ODL::DBBrowse::BrowseSP;


sub main
{
   if (($#ARGV > -1) && ($ARGV[0] eq '--help'))
   {
      print "Harvest\n\n";
      print "  syntax : harvest.pl [ <when> ] [ <what> ] [ <fromwhere> ]\n\n";
      print "  where  : when = {now, *schedule}\n";
      print "           what = {*all, <archiveidentifier>}\n";
      print "           fromwhere = {*last, start}\n";
      print "  * = default\n\n";
      exit;
   }

   chdir "$FindBin::Bin";
   my $harvest = new ODL::DBBrowse::BrowseSP ('config.xml');
   $harvest->harvest ($ARGV[0], $ARGV[1], $ARGV[2]);
   $harvest->dispose;
}

main;
